/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jms.reply;

import java.util.concurrent.ConcurrentSkipListSet;
import org.apache.camel.component.jms.reply.CorrelationListener;
import org.apache.camel.component.jms.reply.CorrelationTimeoutMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSelectorCreator
implements CorrelationListener {
    protected static final Logger LOG = LoggerFactory.getLogger(MessageSelectorCreator.class);
    protected final CorrelationTimeoutMap timeoutMap;
    protected final ConcurrentSkipListSet<String> correlationIds;
    protected volatile boolean dirty = true;
    protected StringBuilder expression;

    public MessageSelectorCreator(CorrelationTimeoutMap timeoutMap) {
        this.timeoutMap = timeoutMap;
        this.timeoutMap.setListener(this);
        this.correlationIds = new ConcurrentSkipListSet();
    }

    public synchronized String get() {
        if (!this.dirty) {
            return this.expression.toString();
        }
        this.expression = new StringBuilder("JMSCorrelationID='");
        if (this.correlationIds.size() == 0) {
            this.expression.append("CamelDummyJmsMessageSelector'");
        } else {
            boolean first = true;
            for (String value : this.correlationIds) {
                if (!first) {
                    this.expression.append(" OR JMSCorrelationID='");
                }
                this.expression.append(value).append("'");
                if (!first) continue;
                first = false;
            }
        }
        String answer = this.expression.toString();
        this.dirty = false;
        return answer;
    }

    @Override
    public void onPut(String key) {
        this.dirty = true;
        this.correlationIds.add(key);
    }

    @Override
    public void onRemove(String key) {
        this.dirty = true;
        this.correlationIds.remove(key);
    }

    @Override
    public void onEviction(String key) {
        this.dirty = true;
        this.correlationIds.remove(key);
    }
}

