/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class EscapeUtil {
    public static final String PATH_ESCAPE = "!";
    public static final String CSV_ESCAPE = "\\\\";
    static final Map<String, Pattern[]> SPLIT_PATTERNS = new HashMap<String, Pattern[]>();
    private static final Pattern ESCAPE_PATTERN;
    private static final Pattern SLASH_PATTERN;

    private EscapeUtil() {
    }

    public static String combineToPath(List<String> pParts) {
        if (pParts != null && pParts.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Iterator<String> it = pParts.iterator();
            while (it.hasNext()) {
                String part = it.next();
                buf.append(EscapeUtil.escapePart(part != null ? part : "*"));
                if (!it.hasNext()) continue;
                buf.append("/");
            }
            return buf.toString();
        }
        return null;
    }

    public static List<String> parsePath(String pPath) {
        if (pPath == null || pPath.equals("") || pPath.equals("/")) {
            return null;
        }
        return EscapeUtil.replaceWildcardsWithNull(EscapeUtil.split(pPath, PATH_ESCAPE, "/"));
    }

    public static Stack<String> extractElementsFromPath(String pPath) {
        return EscapeUtil.reversePath(EscapeUtil.parsePath(pPath));
    }

    public static Stack<String> reversePath(List<String> pathParts) {
        Stack<String> pathStack = new Stack<String>();
        if (pathParts != null) {
            for (int i = pathParts.size() - 1; i >= 0; --i) {
                pathStack.push(pathParts.get(i));
            }
        }
        return pathStack;
    }

    public static List<String> split(String pArg, String pEscape, String pDelimiter) {
        if (pArg != null) {
            ArrayList<String> ret = new ArrayList<String>();
            Pattern[] pattern = SPLIT_PATTERNS.get(pEscape + pDelimiter);
            if (pattern == null) {
                pattern = EscapeUtil.createSplitPatterns(pEscape, pDelimiter);
                SPLIT_PATTERNS.put(pEscape + pDelimiter, pattern);
            }
            Matcher m = pattern[0].matcher(pArg);
            while (m.find() && m.start(1) != pArg.length()) {
                String trailingEscapes = m.group(2);
                ret.add(pattern[1].matcher(m.group(1) + (trailingEscapes != null ? trailingEscapes : "")).replaceAll("$1"));
            }
            return ret;
        }
        return null;
    }

    public static String[] splitAsArray(String pArg, String pEscape, String pDelimiter) {
        if (pArg != null) {
            List<String> elements = EscapeUtil.split(pArg, pEscape, pDelimiter);
            return elements.toArray(new String[elements.size()]);
        }
        return new String[0];
    }

    public static String escape(String pArg, String pEscape, String pDelimiter) {
        return pArg.replaceAll(pEscape, pEscape + pEscape).replaceAll(pDelimiter, pEscape + pDelimiter);
    }

    private static Pattern[] createSplitPatterns(String pEscape, String pDel) {
        return new Pattern[]{Pattern.compile("(.*?)(?:(?<!" + pEscape + ")((?:" + pEscape + ".)*)" + pDel + "|$)", 32), Pattern.compile(pEscape + "(.)", 32)};
    }

    private static String escapePart(String pPart) {
        return SLASH_PATTERN.matcher(ESCAPE_PATTERN.matcher(pPart).replaceAll("!!")).replaceAll("!/");
    }

    private static List<String> replaceWildcardsWithNull(List<String> pParts) {
        if (pParts == null) {
            return null;
        }
        ArrayList<String> ret = new ArrayList<String>(pParts.size());
        for (String part : pParts) {
            ret.add("*".equals(part) ? null : part);
        }
        return ret;
    }

    static {
        for (String[] param : new String[][]{{PATH_ESCAPE, "/"}, {CSV_ESCAPE, ","}, {CSV_ESCAPE, "="}}) {
            String esc = param[0];
            String del = param[1];
            SPLIT_PATTERNS.put(esc + del, EscapeUtil.createSplitPatterns(esc, del));
        }
        ESCAPE_PATTERN = Pattern.compile(PATH_ESCAPE);
        SLASH_PATTERN = Pattern.compile("/");
    }
}

