/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.jaas;

import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.apache.activemq.jaas.CertificateLoginModule;

public class TextFileCertificateLoginModule
extends CertificateLoginModule {
    private static final String USER_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.user";
    private static final String GROUP_FILE_PROP_NAME = "org.apache.activemq.jaas.textfiledn.group";
    private Map<String, Set<String>> groupsByUser;
    private Map<String, Pattern> regexpByUser;
    private Map<String, String> usersByDn;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.usersByDn = this.load(USER_FILE_PROP_NAME, "", options).invertedPropertiesMap();
        this.regexpByUser = this.load(USER_FILE_PROP_NAME, "", options).regexpPropertiesMap();
        this.groupsByUser = this.load(GROUP_FILE_PROP_NAME, "", options).invertedPropertiesValuesMap();
    }

    @Override
    protected String getUserNameForCertificates(X509Certificate[] certs) throws LoginException {
        if (certs == null) {
            throw new LoginException("Client certificates not found. Cannot authenticate.");
        }
        String dn = this.getDistinguishedName(certs);
        return this.usersByDn.containsKey(dn) ? this.usersByDn.get(dn) : this.getUserByRegexp(dn);
    }

    @Override
    protected Set<String> getUserGroups(String username) throws LoginException {
        Set<String> userGroups = this.groupsByUser.get(username);
        if (userGroups == null) {
            userGroups = Collections.emptySet();
        }
        return userGroups;
    }

    private synchronized String getUserByRegexp(String dn) {
        String name = null;
        for (Map.Entry<String, Pattern> val : this.regexpByUser.entrySet()) {
            if (!val.getValue().matcher(dn).matches()) continue;
            name = val.getKey();
            break;
        }
        this.usersByDn.put(dn, name);
        return name;
    }
}

