/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.protobuf.compiler;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.protobuf.compiler.EnumFieldDescriptor;
import org.apache.activemq.protobuf.compiler.MessageDescriptor;
import org.apache.activemq.protobuf.compiler.OptionDescriptor;
import org.apache.activemq.protobuf.compiler.ProtoDescriptor;
import org.apache.activemq.protobuf.compiler.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumDescriptor
implements TypeDescriptor {
    private String name;
    private Map<String, EnumFieldDescriptor> fields = new LinkedHashMap<String, EnumFieldDescriptor>();
    private final ProtoDescriptor protoDescriptor;
    private final MessageDescriptor parent;
    private Map<String, OptionDescriptor> options = new LinkedHashMap<String, OptionDescriptor>();

    public EnumDescriptor(ProtoDescriptor protoDescriptor, MessageDescriptor parent) {
        this.protoDescriptor = protoDescriptor;
        this.parent = parent;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Map<String, EnumFieldDescriptor> getFields() {
        return this.fields;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(Map<String, EnumFieldDescriptor> fields) {
        this.fields = fields;
    }

    @Override
    public ProtoDescriptor getProtoDescriptor() {
        return this.protoDescriptor;
    }

    private String getOption(Map<String, OptionDescriptor> options, String optionName, String defaultValue) {
        OptionDescriptor optionDescriptor = options.get(optionName);
        if (optionDescriptor == null) {
            return defaultValue;
        }
        return optionDescriptor.getValue();
    }

    private String constantToUCamelCase(String name) {
        boolean upNext = true;
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < name.length(); ++i2) {
            char c = name.charAt(i2);
            if (Character.isJavaIdentifierPart(c) && Character.isLetterOrDigit(c)) {
                if (upNext) {
                    c = Character.toUpperCase(c);
                    upNext = false;
                } else {
                    c = Character.toLowerCase(c);
                }
                sb.append(c);
                continue;
            }
            upNext = true;
        }
        return sb.toString();
    }

    public void validate(List<String> errors) {
        String createMessage = this.getOption(this.getOptions(), "java_create_message", null);
        if ("true".equals(createMessage)) {
            for (EnumFieldDescriptor field : this.getFields().values()) {
                String type = this.constantToUCamelCase(field.getName());
                TypeDescriptor typeDescriptor = null;
                if (this.parent != null) {
                    typeDescriptor = this.parent.getType(type);
                }
                if (typeDescriptor == null) {
                    typeDescriptor = this.protoDescriptor.getType(type);
                }
                if (typeDescriptor == null) {
                    errors.add("ENUM constant '" + field.getName() + "' did not find expected associated message: " + type);
                    continue;
                }
                field.associate(typeDescriptor);
                typeDescriptor.associate(field);
            }
        }
    }

    public MessageDescriptor getParent() {
        return this.parent;
    }

    @Override
    public String getQName() {
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.getQName() + "." + this.name;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    public Map<String, OptionDescriptor> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, OptionDescriptor> options) {
        this.options = options;
    }

    @Override
    public void associate(EnumFieldDescriptor desc) {
        throw new RuntimeException("not supported.");
    }
}

