/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import javax.net.SocketFactory;
import org.apache.activemq.transport.amqp.AmqpFrameParser;
import org.apache.activemq.transport.amqp.AmqpWireFormat;
import org.apache.activemq.transport.nio.NIOOutputStream;
import org.apache.activemq.transport.nio.SelectorManager;
import org.apache.activemq.transport.nio.SelectorSelection;
import org.apache.activemq.transport.tcp.TcpTransport;
import org.apache.activemq.util.IOExceptionSupport;
import org.apache.activemq.util.ServiceStopper;
import org.apache.activemq.wireformat.WireFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AmqpNioTransport
extends TcpTransport {
    private static final Logger LOG = LoggerFactory.getLogger(AmqpNioTransport.class);
    private SocketChannel channel;
    private SelectorSelection selection;
    private final AmqpFrameParser frameReader = new AmqpFrameParser(this);
    private ByteBuffer inputBuffer;
    boolean magicRead = false;

    public AmqpNioTransport(WireFormat wireFormat, SocketFactory socketFactory, URI remoteLocation, URI localLocation) throws UnknownHostException, IOException {
        super(wireFormat, socketFactory, remoteLocation, localLocation);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    public AmqpNioTransport(WireFormat wireFormat, Socket socket) throws IOException {
        super(wireFormat, socket);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    public AmqpNioTransport(WireFormat wireFormat, Socket socket, TcpTransport.InitBuffer initBuffer) throws IOException {
        super(wireFormat, socket, initBuffer);
        this.frameReader.setWireFormat((AmqpWireFormat)wireFormat);
    }

    @Override
    protected void initializeStreams() throws IOException {
        this.channel = this.socket.getChannel();
        this.channel.configureBlocking(false);
        this.selection = SelectorManager.getInstance().register(this.channel, new SelectorManager.Listener(){

            @Override
            public void onSelect(SelectorSelection selection) {
                if (!AmqpNioTransport.this.isStopped()) {
                    AmqpNioTransport.this.serviceRead();
                }
            }

            @Override
            public void onError(SelectorSelection selection, Throwable error) {
                LOG.trace("Error detected: {}", (Object)error.getMessage());
                if (error instanceof IOException) {
                    AmqpNioTransport.this.onException((IOException)error);
                } else {
                    AmqpNioTransport.this.onException(IOExceptionSupport.create(error));
                }
            }
        });
        this.inputBuffer = ByteBuffer.allocate(8192);
        NIOOutputStream outPutStream = new NIOOutputStream(this.channel, 8192);
        this.dataOut = new DataOutputStream(outPutStream);
        this.buffOut = outPutStream;
        try {
            if (this.initBuffer != null) {
                this.processBuffer(this.initBuffer.buffer, this.initBuffer.readSize);
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    private void serviceRead() {
        try {
            while (this.isStarted()) {
                int readSize = this.channel.read(this.inputBuffer);
                if (readSize == -1) {
                    this.onException(new EOFException());
                    this.selection.close();
                } else if (readSize != 0) {
                    this.processBuffer(this.inputBuffer, readSize);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            this.onException(e);
        }
        catch (Throwable e) {
            this.onException(IOExceptionSupport.create(e));
        }
    }

    protected void processBuffer(ByteBuffer buffer, int readSize) throws Exception {
        this.receiveCounter.addAndGet(readSize);
        buffer.flip();
        this.frameReader.parse(buffer);
        buffer.clear();
    }

    @Override
    protected void doStart() throws Exception {
        this.connect();
        this.selection.setInterestOps(1);
        this.selection.enable();
    }

    @Override
    protected void doStop(ServiceStopper stopper) throws Exception {
        try {
            if (this.selection != null) {
                this.selection.close();
            }
        }
        finally {
            super.doStop(stopper);
        }
    }
}

