/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.engine.impl;

import java.nio.ByteBuffer;
import org.apache.qpid.proton.amqp.Binary;
import org.apache.qpid.proton.amqp.security.SaslFrameBody;
import org.apache.qpid.proton.amqp.transport.EmptyFrame;
import org.apache.qpid.proton.amqp.transport.FrameBody;
import org.apache.qpid.proton.codec.EncoderImpl;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.impl.FrameWriterBuffer;
import org.apache.qpid.proton.engine.impl.ProtocolTracer;
import org.apache.qpid.proton.engine.impl.TransportImpl;
import org.apache.qpid.proton.framing.TransportFrame;

class FrameWriter {
    static final int DEFAULT_FRAME_BUFFER_FULL_MARK = 65536;
    static final int FRAME_HEADER_SIZE = 8;
    static final byte AMQP_FRAME_TYPE = 0;
    static final byte SASL_FRAME_TYPE = 1;
    private final TransportImpl transport;
    private final EncoderImpl encoder;
    private final FrameWriterBuffer frameBuffer = new FrameWriterBuffer();
    private int maxFrameSize;
    private final byte frameType;
    private int frameBufferMaxBytes = 65536;
    private int frameStart;
    private long framesOutput;

    FrameWriter(EncoderImpl encoder, int maxFrameSize, byte frameType, TransportImpl transport) {
        this.encoder = encoder;
        this.maxFrameSize = maxFrameSize;
        this.frameType = frameType;
        this.transport = transport;
        encoder.setByteBuffer(this.frameBuffer);
    }

    boolean isFull() {
        return this.frameBuffer.position() > this.frameBufferMaxBytes;
    }

    int readBytes(ByteBuffer dst) {
        return this.frameBuffer.transferTo(dst);
    }

    long getFramesOutput() {
        return this.framesOutput;
    }

    void setMaxFrameSize(int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
    }

    void setFrameWriterMaxBytes(int maxBytes) {
        this.frameBufferMaxBytes = maxBytes;
    }

    int getFrameWriterMaxBytes() {
        return this.frameBufferMaxBytes;
    }

    void writeHeader(byte[] header) {
        this.frameBuffer.put(header, 0, header.length);
    }

    void writeFrame(Object frameBody) {
        this.writeFrame(0, frameBody, null, null);
    }

    void writeFrame(int channel, Object frameBody, ReadableBuffer payload, Runnable onPayloadTooLarge) {
        this.frameStart = this.frameBuffer.position();
        try {
            int performativeSize = this.writePerformative(frameBody, payload, onPayloadTooLarge);
            int capacity = this.maxFrameSize > 0 ? this.maxFrameSize - performativeSize : Integer.MAX_VALUE;
            int payloadSize = Math.min(payload == null ? 0 : payload.remaining(), capacity);
            if (this.transport.isFrameTracingEnabled()) {
                this.logFrame(channel, frameBody, payload, payloadSize);
            }
            if (payloadSize > 0) {
                int oldLimit = payload.limit();
                payload.limit(payload.position() + payloadSize);
                this.frameBuffer.put(payload);
                payload.limit(oldLimit);
            }
            this.endFrame(channel);
            ++this.framesOutput;
        }
        catch (Exception e) {
            this.frameBuffer.position(this.frameStart);
            throw e;
        }
    }

    private int writePerformative(Object frameBody, ReadableBuffer payload, Runnable onPayloadTooLarge) {
        this.frameBuffer.position(this.frameStart + 8);
        if (frameBody != null) {
            this.encoder.writeObject(frameBody);
        }
        int performativeSize = this.frameBuffer.position() - this.frameStart;
        if (onPayloadTooLarge != null && this.maxFrameSize > 0 && payload != null && payload.remaining() + performativeSize > this.maxFrameSize) {
            onPayloadTooLarge.run();
            performativeSize = this.writePerformative(frameBody, payload, null);
        }
        return performativeSize;
    }

    private void endFrame(int channel) {
        int frameSize = this.frameBuffer.position() - this.frameStart;
        int originalPosition = this.frameBuffer.position();
        this.frameBuffer.position(this.frameStart);
        this.frameBuffer.putInt(frameSize);
        this.frameBuffer.put((byte)2);
        this.frameBuffer.put(this.frameType);
        this.frameBuffer.putShort((short)channel);
        this.frameBuffer.position(originalPosition);
    }

    private void logFrame(int channel, Object frameBody, ReadableBuffer payload, int payloadSize) {
        ProtocolTracer tracer = this.transport.getProtocolTracer();
        if (this.frameType == 0) {
            ReadableBuffer originalPayload = null;
            if (payload != null) {
                originalPayload = payload.slice();
                originalPayload.limit(payloadSize);
            }
            Binary payloadBin = Binary.create(originalPayload);
            FrameBody body = null;
            body = frameBody == null ? EmptyFrame.INSTANCE : (FrameBody)frameBody;
            TransportFrame frame = new TransportFrame(channel, body, payloadBin);
            this.transport.log(TransportImpl.OUTGOING, frame);
            if (tracer != null) {
                tracer.sentFrame(frame);
            }
        } else {
            SaslFrameBody body = (SaslFrameBody)frameBody;
            this.transport.log(TransportImpl.OUTGOING, body);
            if (tracer != null) {
                tracer.sentSaslBody(body);
            }
        }
    }
}

