/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.activemq.broker.jmx.BrokerViewMBean;
import org.apache.activemq.broker.jmx.ManagementContext;
import org.apache.activemq.broker.jmx.QueueViewMBean;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.web.BrokerFacadeSupport;
import org.apache.activemq.web.config.WebConsoleConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteJMXBrokerFacade
extends BrokerFacadeSupport {
    private static final transient Logger LOG = LoggerFactory.getLogger(RemoteJMXBrokerFacade.class);
    private String brokerName;
    private JMXConnector connector;
    private WebConsoleConfiguration configuration;

    public void setBrokerName(String brokerName) {
        this.brokerName = brokerName;
    }

    public WebConsoleConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(WebConsoleConfiguration configuration) {
        this.configuration = configuration;
    }

    public void shutdown() {
        this.closeConnection();
    }

    @Override
    public BrokerViewMBean getBrokerAdmin() throws Exception {
        MBeanServerConnection connection = this.getMBeanServerConnection();
        Set<ObjectName> brokers = this.findBrokers(connection);
        if (brokers.size() == 0) {
            throw new IOException("No broker could be found in the JMX.");
        }
        ObjectName name = brokers.iterator().next();
        BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, name, BrokerViewMBean.class, true);
        return mbean;
    }

    @Override
    public String getBrokerName() throws Exception, MalformedObjectNameException {
        return this.getBrokerAdmin().getBrokerName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MBeanServerConnection getMBeanServerConnection() throws Exception {
        JMXConnector connector = this.connector;
        if (this.isConnectionActive(connector)) {
            return connector.getMBeanServerConnection();
        }
        RemoteJMXBrokerFacade remoteJMXBrokerFacade = this;
        synchronized (remoteJMXBrokerFacade) {
            this.closeConnection();
            LOG.debug("Creating a new JMX-Connection to the broker");
            this.connector = this.createConnection();
            return this.connector.getMBeanServerConnection();
        }
    }

    protected boolean isConnectionActive(JMXConnector connector) {
        if (connector == null) {
            return false;
        }
        try {
            MBeanServerConnection connection = connector.getMBeanServerConnection();
            int brokerCount = this.findBrokers(connection).size();
            return brokerCount > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected JMXConnector createConnection() {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (this.configuration.getJmxUser() != null) {
            env.put("jmx.remote.credentials", new String[]{this.configuration.getJmxUser(), this.configuration.getJmxPassword()});
        }
        Collection<JMXServiceURL> jmxUrls = this.configuration.getJmxUrls();
        Exception exception = null;
        for (JMXServiceURL url : jmxUrls) {
            try {
                JMXConnector connector = JMXConnectorFactory.connect(url, env);
                connector.connect();
                MBeanServerConnection connection = connector.getMBeanServerConnection();
                Set<ObjectName> brokers = this.findBrokers(connection);
                if (brokers.size() <= 0) continue;
                LOG.info("Connected via JMX to the broker at " + String.valueOf(url));
                return connector;
            }
            catch (Exception e) {
                exception = e;
            }
        }
        if (exception != null) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new RuntimeException(exception);
        }
        throw new IllegalStateException("No broker is found at any of the " + jmxUrls.size() + " configured urls");
    }

    protected synchronized void closeConnection() {
        if (this.connector != null) {
            try {
                LOG.debug("Closing a connection to a broker (" + this.connector.getConnectionId() + ")");
                this.connector.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected Set<ObjectName> findBrokers(MBeanServerConnection connection) throws IOException, MalformedObjectNameException {
        ObjectName name = this.brokerName == null ? new ObjectName("org.apache.activemq:type=Broker,brokerName=*") : new ObjectName("org.apache.activemq:type=Broker,brokerName=" + this.brokerName);
        Set<ObjectName> brokers = connection.queryNames(name, null);
        HashSet<ObjectName> masterBrokers = new HashSet<ObjectName>();
        for (ObjectName objectName : brokers) {
            BrokerViewMBean mbean = MBeanServerInvocationHandler.newProxyInstance(connection, objectName, BrokerViewMBean.class, true);
            if (mbean.isSlave()) continue;
            masterBrokers.add(objectName);
        }
        return masterBrokers;
    }

    @Override
    public void purgeQueue(ActiveMQDestination destination) throws Exception {
        QueueViewMBean queue = this.getQueue(destination.getPhysicalName());
        queue.purge();
    }

    @Override
    public ManagementContext getManagementContext() {
        throw new IllegalStateException("not supported");
    }

    @Override
    protected <T> Collection<T> getManagedObjects(ObjectName[] names, Class<T> type) {
        MBeanServerConnection connection;
        try {
            connection = this.getMBeanServerConnection();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ArrayList<T> answer = new ArrayList<T>();
        if (connection != null) {
            for (int i = 0; i < names.length; ++i) {
                ObjectName name = names[i];
                T value = MBeanServerInvocationHandler.newProxyInstance(connection, name, type, true);
                if (value == null) continue;
                answer.add(value);
            }
        }
        return answer;
    }

    @Override
    public Set queryNames(ObjectName name, QueryExp query) throws Exception {
        return this.getMBeanServerConnection().queryNames(name, query);
    }

    @Override
    public Object newProxyInstance(ObjectName objectName, Class interfaceClass, boolean notificationBroadcaster) throws Exception {
        return MBeanServerInvocationHandler.newProxyInstance(this.getMBeanServerConnection(), objectName, interfaceClass, notificationBroadcaster);
    }
}

