/*
 * Decompiled with CFR 0.152.
 */
package org.jasypt.spring4.xml.encryption;

import java.util.Properties;
import org.jasypt.spring4.xml.encryption.EncryptablePropertiesFactoryBean;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

final class EncryptablePropertiesBeanDefinitionParser
extends AbstractSimpleBeanDefinitionParser {
    private static final String SCOPE_ATTRIBUTE = "scope";
    private static final String ENCRYPTOR_ATTRIBUTE = "encryptor";

    EncryptablePropertiesBeanDefinitionParser() {
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return super.isEligibleAttribute(attributeName) && !SCOPE_ATTRIBUTE.equals(attributeName) && !ENCRYPTOR_ATTRIBUTE.equals(attributeName);
    }

    protected Class<?> getBeanClass(Element element) {
        return EncryptablePropertiesFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        String encryptorBeanName;
        super.doParse(element, parserContext, builder);
        Properties parsedProps = parserContext.getDelegate().parsePropsElement(element);
        builder.addPropertyValue("properties", (Object)parsedProps);
        String scope = element.getAttribute(SCOPE_ATTRIBUTE);
        if (StringUtils.hasLength((String)scope)) {
            builder.setScope(scope);
        }
        if (StringUtils.hasText((String)(encryptorBeanName = element.getAttribute(ENCRYPTOR_ATTRIBUTE)))) {
            builder.addPropertyReference(ENCRYPTOR_ATTRIBUTE, encryptorBeanName);
        }
    }
}

