/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Properties;
import org.apache.camel.Exchange;
import org.apache.camel.StreamCache;
import org.apache.camel.converter.IOConverter;

public final class IOConverterOptimised {
    private IOConverterOptimised() {
    }

    public static Object convertTo(Class<?> type, Exchange exchange, Object value) throws Exception {
        Class<?> fromType = value.getClass();
        if (value instanceof StreamCache) {
            ((StreamCache)value).reset();
        }
        if (type == InputStream.class) {
            if (fromType == String.class) {
                return IOConverter.toInputStream((String)value, exchange);
            }
            if (fromType == URL.class) {
                return IOConverter.toInputStream((URL)value);
            }
            if (fromType == File.class) {
                return IOConverter.toInputStream((File)value);
            }
            if (fromType == byte[].class) {
                return IOConverter.toInputStream((byte[])value);
            }
            if (fromType == ByteArrayOutputStream.class) {
                return IOConverter.toInputStream((ByteArrayOutputStream)value);
            }
            if (fromType == BufferedReader.class) {
                return IOConverter.toInputStream((BufferedReader)value, exchange);
            }
            if (fromType == StringBuilder.class) {
                return IOConverter.toInputStream((StringBuilder)value, exchange);
            }
            return null;
        }
        if (type == Reader.class) {
            if (fromType == File.class) {
                return IOConverter.toReader((File)value, exchange);
            }
            if (fromType == String.class) {
                return IOConverter.toReader((String)value);
            }
            if (InputStream.class.isAssignableFrom(fromType)) {
                return IOConverter.toReader((InputStream)value, exchange);
            }
            return null;
        }
        if (type == File.class) {
            if (fromType == String.class) {
                return IOConverter.toFile((String)value);
            }
            return null;
        }
        if (type == OutputStream.class) {
            if (fromType == File.class) {
                return IOConverter.toOutputStream((File)value);
            }
            return null;
        }
        if (type == Writer.class) {
            if (fromType == File.class) {
                return IOConverter.toWriter((File)value, exchange);
            }
            if (OutputStream.class.isAssignableFrom(fromType)) {
                return IOConverter.toWriter((OutputStream)value, exchange);
            }
            return null;
        }
        if (type == String.class) {
            if (fromType == byte[].class) {
                return IOConverter.toString((byte[])value, exchange);
            }
            if (fromType == File.class) {
                return IOConverter.toString((File)value, exchange);
            }
            if (fromType == URL.class) {
                return IOConverter.toString((URL)value, exchange);
            }
            if (fromType == BufferedReader.class) {
                return IOConverter.toString((BufferedReader)value);
            }
            if (Reader.class.isAssignableFrom(fromType)) {
                return IOConverter.toString((Reader)value);
            }
            if (InputStream.class.isAssignableFrom(fromType)) {
                return IOConverter.toString((InputStream)value, exchange);
            }
            if (fromType == ByteArrayOutputStream.class) {
                return IOConverter.toString((ByteArrayOutputStream)value, exchange);
            }
            return null;
        }
        if (type == byte[].class) {
            if (fromType == BufferedReader.class) {
                return IOConverter.toByteArray((BufferedReader)value, exchange);
            }
            if (Reader.class.isAssignableFrom(fromType)) {
                return IOConverter.toByteArray((Reader)value, exchange);
            }
            if (fromType == File.class) {
                return IOConverter.toByteArray((File)value);
            }
            if (fromType == String.class) {
                return IOConverter.toByteArray((String)value, exchange);
            }
            if (fromType == ByteArrayOutputStream.class) {
                return IOConverter.toByteArray((ByteArrayOutputStream)value);
            }
            if (InputStream.class.isAssignableFrom(fromType)) {
                return IOConverter.toBytes((InputStream)value);
            }
            return null;
        }
        if (type == ObjectInput.class) {
            if (fromType == InputStream.class || fromType == BufferedInputStream.class) {
                return IOConverter.toObjectInput((InputStream)value, exchange);
            }
            return null;
        }
        if (type == ObjectOutput.class) {
            if (fromType == OutputStream.class) {
                return IOConverter.toObjectOutput((OutputStream)value);
            }
            return null;
        }
        if (type == Properties.class) {
            if (fromType == File.class) {
                return IOConverter.toProperties((File)value);
            }
            if (fromType == InputStream.class) {
                return IOConverter.toProperties((InputStream)value);
            }
            if (fromType == Reader.class) {
                return IOConverter.toProperties((Reader)value);
            }
            return null;
        }
        return null;
    }
}

