/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import org.apache.camel.CamelContext;
import org.apache.camel.LoggingLevel;
import org.apache.camel.api.management.ManagedNotification;
import org.apache.camel.api.management.ManagedNotifications;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.NotificationSender;
import org.apache.camel.api.management.NotificationSenderAware;
import org.apache.camel.api.management.mbean.ManagedTracerMBean;
import org.apache.camel.management.mbean.JMXNotificationTraceEventHandler;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ObjectHelper;

@ManagedResource(description="Managed Tracer")
@ManagedNotifications(value={@ManagedNotification(name="javax.management.Notification", description="Fine grained trace events", notificationTypes={"TraceNotification"})})
public class ManagedTracer
implements NotificationSenderAware,
ManagedTracerMBean {
    private final CamelContext camelContext;
    private final Tracer tracer;
    private JMXNotificationTraceEventHandler jmxTraceHandler;

    public ManagedTracer(CamelContext camelContext, Tracer tracer) {
        this.camelContext = camelContext;
        this.tracer = tracer;
        this.jmxTraceHandler = new JMXNotificationTraceEventHandler(tracer);
        tracer.addTraceHandler(this.jmxTraceHandler);
    }

    public void init(ManagementStrategy strategy) {
    }

    public CamelContext getContext() {
        return this.camelContext;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    @Override
    public String getCamelId() {
        return this.camelContext.getName();
    }

    @Override
    public String getCamelManagementName() {
        return this.camelContext.getManagementName();
    }

    @Override
    public boolean getEnabled() {
        return this.tracer.isEnabled();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.tracer.setEnabled(enabled);
    }

    @Override
    public String getDestinationUri() {
        return this.tracer.getDestinationUri();
    }

    @Override
    public void setDestinationUri(String uri) {
        if (ObjectHelper.isEmpty(uri)) {
            this.tracer.setDestinationUri(null);
        } else {
            this.tracer.setDestinationUri(uri);
        }
    }

    @Override
    public String getLogName() {
        return this.tracer.getLogName();
    }

    @Override
    public boolean getUseJpa() {
        return this.tracer.isUseJpa();
    }

    @Override
    public void setLogName(String logName) {
        this.tracer.setLogName(logName);
    }

    @Override
    public String getLogLevel() {
        return this.tracer.getLogLevel().name();
    }

    @Override
    public void setLogLevel(String logLevel) {
        this.tracer.setLogLevel(LoggingLevel.valueOf(logLevel));
    }

    @Override
    public boolean getLogStackTrace() {
        return this.tracer.isLogStackTrace();
    }

    @Override
    public void setLogStackTrace(boolean logStackTrace) {
        this.tracer.setLogStackTrace(logStackTrace);
    }

    @Override
    public boolean getTraceInterceptors() {
        return this.tracer.isTraceInterceptors();
    }

    @Override
    public void setTraceInterceptors(boolean traceInterceptors) {
        this.tracer.setTraceInterceptors(traceInterceptors);
    }

    @Override
    public boolean getTraceExceptions() {
        return this.tracer.isTraceExceptions();
    }

    @Override
    public void setTraceExceptions(boolean traceExceptions) {
        this.tracer.setTraceExceptions(traceExceptions);
    }

    @Override
    public boolean getTraceOutExchanges() {
        return this.tracer.isTraceOutExchanges();
    }

    @Override
    public void setTraceOutExchanges(boolean traceOutExchanges) {
        this.tracer.setTraceOutExchanges(traceOutExchanges);
    }

    @Override
    public boolean getFormatterShowBody() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBody();
    }

    @Override
    public void setFormatterShowBody(boolean showBody) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBody(showBody);
    }

    @Override
    public boolean getFormatterShowBodyType() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBodyType();
    }

    @Override
    public void setFormatterShowBodyType(boolean showBodyType) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBodyType(showBodyType);
    }

    @Override
    public boolean getFormatterShowOutBody() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutBody();
    }

    @Override
    public void setFormatterShowOutBody(boolean showOutBody) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutBody(showOutBody);
    }

    @Override
    public boolean getFormatterShowOutBodyType() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutBodyType();
    }

    @Override
    public void setFormatterShowOutBodyType(boolean showOutBodyType) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutBodyType(showOutBodyType);
    }

    @Override
    public boolean getFormatterShowBreadCrumb() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowBreadCrumb();
    }

    @Override
    public void setFormatterShowBreadCrumb(boolean showBreadCrumb) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowBreadCrumb(showBreadCrumb);
    }

    @Override
    public boolean getFormatterShowExchangeId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowExchangeId();
    }

    @Override
    public void setFormatterShowExchangeId(boolean showExchangeId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowExchangeId(showExchangeId);
    }

    @Override
    public boolean getFormatterShowHeaders() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowHeaders();
    }

    @Override
    public void setFormatterShowHeaders(boolean showHeaders) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowHeaders(showHeaders);
    }

    @Override
    public boolean getFormatterShowOutHeaders() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowOutHeaders();
    }

    @Override
    public void setFormatterShowOutHeaders(boolean showOutHeaders) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowOutHeaders(showOutHeaders);
    }

    @Override
    public boolean getFormatterShowProperties() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowProperties();
    }

    @Override
    public void setFormatterShowProperties(boolean showProperties) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowProperties(showProperties);
    }

    public boolean getFormatterMultiline() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isMultiline();
    }

    public void setFormatterMultiline(boolean multiline) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setMultiline(multiline);
    }

    @Override
    public boolean getFormatterShowNode() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowNode();
    }

    @Override
    public void setFormatterShowNode(boolean showNode) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowNode(showNode);
    }

    @Override
    public boolean getFormatterShowExchangePattern() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowExchangePattern();
    }

    @Override
    public void setFormatterShowExchangePattern(boolean showExchangePattern) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowExchangePattern(showExchangePattern);
    }

    @Override
    public boolean getFormatterShowException() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowException();
    }

    @Override
    public void setFormatterShowException(boolean showException) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowException(showException);
    }

    @Override
    public boolean getFormatterShowRouteId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowRouteId();
    }

    @Override
    public void setFormatterShowRouteId(boolean showRouteId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowRouteId(showRouteId);
    }

    @Override
    public int getFormatterBreadCrumbLength() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getBreadCrumbLength();
    }

    @Override
    public void setFormatterBreadCrumbLength(int breadCrumbLength) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setBreadCrumbLength(breadCrumbLength);
    }

    @Override
    public boolean getFormatterShowShortExchangeId() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return false;
        }
        return this.tracer.getDefaultTraceFormatter().isShowShortExchangeId();
    }

    @Override
    public void setFormatterShowShortExchangeId(boolean showShortExchangeId) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setShowShortExchangeId(showShortExchangeId);
    }

    @Override
    public int getFormatterNodeLength() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getNodeLength();
    }

    @Override
    public void setFormatterNodeLength(int nodeLength) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setNodeLength(nodeLength);
    }

    @Override
    public int getFormatterMaxChars() {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return 0;
        }
        return this.tracer.getDefaultTraceFormatter().getMaxChars();
    }

    @Override
    public void setFormatterMaxChars(int maxChars) {
        if (this.tracer.getDefaultTraceFormatter() == null) {
            return;
        }
        this.tracer.getDefaultTraceFormatter().setMaxChars(maxChars);
    }

    @Override
    public boolean isJmxTraceNotifications() {
        return this.tracer.isJmxTraceNotifications();
    }

    @Override
    public void setJmxTraceNotifications(boolean jmxTraceNotifications) {
        this.tracer.setJmxTraceNotifications(jmxTraceNotifications);
    }

    @Override
    public int getTraceBodySize() {
        return this.tracer.getTraceBodySize();
    }

    @Override
    public void setTraceBodySize(int traceBodySize) {
        this.tracer.setTraceBodySize(traceBodySize);
    }

    @Override
    public void setNotificationSender(NotificationSender sender) {
        this.jmxTraceHandler.setNotificationSender(sender);
    }
}

