/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Processor;
import org.apache.camel.component.bean.BeanHolder;
import org.apache.camel.component.bean.BeanInfo;
import org.apache.camel.component.bean.BeanProcessor;
import org.apache.camel.component.bean.ConstantBeanHolder;
import org.apache.camel.component.bean.ConstantStaticTypeBeanHolder;
import org.apache.camel.component.bean.ConstantTypeBeanHolder;
import org.apache.camel.component.bean.MethodNotFoundException;
import org.apache.camel.component.bean.RegistryBean;
import org.apache.camel.model.NoOutputDefinition;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@Metadata(label="eip,endpoint")
@XmlRootElement(name="bean")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class BeanDefinition
extends NoOutputDefinition<BeanDefinition> {
    @XmlAttribute
    private String ref;
    @XmlAttribute
    private String method;
    @XmlAttribute
    private String beanType;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean cache;
    @XmlAttribute
    @Deprecated
    private Boolean multiParameterArray;
    @XmlTransient
    private Class<?> beanClass;
    @XmlTransient
    private Object bean;

    public BeanDefinition() {
    }

    public BeanDefinition(String ref) {
        this.ref = ref;
    }

    public BeanDefinition(String ref, String method) {
        this.ref = ref;
        this.method = method;
    }

    public String toString() {
        return "Bean[" + this.description() + "]";
    }

    public String description() {
        if (this.ref != null) {
            String methodText = "";
            if (this.method != null) {
                methodText = " method:" + this.method;
            }
            return "ref:" + this.ref + methodText;
        }
        if (this.bean != null) {
            return ObjectHelper.className(this.bean);
        }
        if (this.beanClass != null) {
            return this.beanClass.getName();
        }
        if (this.beanType != null) {
            return this.beanType;
        }
        return "";
    }

    @Override
    public String getShortName() {
        return "bean";
    }

    @Override
    public String getLabel() {
        return "bean[" + this.description() + "]";
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        this.ref = ref;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    public String getBeanType() {
        return this.beanType;
    }

    public void setBeanType(String beanType) {
        this.beanType = beanType;
    }

    public void setBeanType(Class<?> beanType) {
        this.beanClass = beanType;
    }

    public Boolean getCache() {
        return this.cache;
    }

    public void setCache(Boolean cache) {
        this.cache = cache;
    }

    public Boolean getMultiParameterArray() {
        return this.multiParameterArray;
    }

    @Deprecated
    public void setMultiParameterArray(Boolean multiParameterArray) {
        this.multiParameterArray = multiParameterArray;
    }

    @Deprecated
    public BeanDefinition ref(String ref) {
        this.setRef(ref);
        return this;
    }

    @Deprecated
    public BeanDefinition method(String method) {
        this.setMethod(method);
        return this;
    }

    @Override
    @Deprecated
    public BeanDefinition bean(Object bean) {
        this.setBean(bean);
        return this;
    }

    @Deprecated
    public BeanDefinition beanType(Class<?> beanType) {
        this.setBeanType(beanType);
        return this;
    }

    @Deprecated
    public BeanDefinition cache() {
        this.setCache(true);
        return this;
    }

    @Override
    public Processor createProcessor(RouteContext routeContext) throws Exception {
        BeanProcessor answer;
        BeanHolder beanHolder;
        Class<?> clazz;
        Class<?> clazz2 = clazz = this.bean != null ? this.bean.getClass() : null;
        if (ObjectHelper.isNotEmpty(this.ref)) {
            if (this.isCacheBean()) {
                beanHolder = new RegistryBean(routeContext.getCamelContext(), this.ref).createCacheHolder();
                this.bean = beanHolder.getBean();
            } else {
                beanHolder = new RegistryBean(routeContext.getCamelContext(), this.ref);
            }
            answer = new BeanProcessor(beanHolder);
        } else {
            if (this.bean == null) {
                if (this.beanType == null && this.beanClass == null) {
                    throw new IllegalArgumentException("bean, ref or beanType must be provided");
                }
                if (this.beanType != null) {
                    try {
                        clazz = routeContext.getCamelContext().getClassResolver().resolveMandatoryClass(this.beanType);
                    }
                    catch (ClassNotFoundException e) {
                        throw ObjectHelper.wrapRuntimeCamelException(e);
                    }
                } else {
                    clazz = this.beanClass;
                }
                if (this.isCacheBean() && routeContext.getCamelContext().getInjector().supportsAutoWiring()) {
                    try {
                        this.log.debug("Attempting to create new bean instance from class: {} via auto-wiring enabled", clazz);
                        this.bean = CamelContextHelper.newInstance(routeContext.getCamelContext(), clazz);
                    }
                    catch (Throwable e) {
                        this.log.debug("Error creating new bean instance from class: " + clazz + ". This exception is ignored", e);
                    }
                }
                if (this.bean == null && this.isCacheBean() && ObjectHelper.hasDefaultPublicNoArgConstructor(clazz)) {
                    this.log.debug("Class has default no-arg constructor so creating a new bean instance: {}", clazz);
                    this.bean = CamelContextHelper.newInstance(routeContext.getCamelContext(), clazz);
                    ObjectHelper.notNull(this.bean, "bean", this);
                }
            }
            if (this.bean instanceof String) {
                throw new IllegalArgumentException("The bean instance is a java.lang.String type: " + this.bean + ". We suppose you want to refer to a bean instance by its id instead. Please use ref.");
            }
            beanHolder = this.bean != null ? new ConstantBeanHolder(this.bean, routeContext.getCamelContext()) : (this.isCacheBean() && ObjectHelper.hasDefaultPublicNoArgConstructor(clazz) ? new ConstantTypeBeanHolder(clazz, routeContext.getCamelContext()).createCacheHolder() : (ObjectHelper.hasDefaultPublicNoArgConstructor(clazz) ? new ConstantTypeBeanHolder(clazz, routeContext.getCamelContext()) : new ConstantStaticTypeBeanHolder(clazz, routeContext.getCamelContext())));
            answer = new BeanProcessor(beanHolder);
        }
        if (this.multiParameterArray != null) {
            answer.setMultiParameterArray(this.multiParameterArray);
        }
        if (this.method != null) {
            answer.setMethod(this.method);
            if (this.isCacheBean()) {
                BeanInfo beanInfo = beanHolder.getBeanInfo();
                if (this.bean != null) {
                    if (!beanInfo.hasMethod(this.method)) {
                        throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, this.bean, this.method));
                    }
                } else if (clazz != null && !beanInfo.hasStaticMethod(this.method)) {
                    throw ObjectHelper.wrapRuntimeCamelException(new MethodNotFoundException(null, clazz, this.method, true));
                }
            }
        }
        return answer;
    }

    private boolean isCacheBean() {
        return this.cache == null || this.cache != false;
    }
}

