/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

@Metadata(firstVersion="2.1.0", label="dataformat,transformation,csv", title="Flatpack")
@XmlRootElement(name="flatpack")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FlatpackDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String definition;
    @XmlAttribute
    private Boolean fixed;
    @XmlAttribute
    @Metadata(defaultValue="true")
    private Boolean ignoreFirstRecord;
    @XmlAttribute
    private String textQualifier;
    @XmlAttribute
    @Metadata(defaultValue=",")
    private String delimiter;
    @XmlAttribute
    private Boolean allowShortLines;
    @XmlAttribute
    private Boolean ignoreExtraColumns;
    @XmlAttribute
    @Metadata(label="advanced")
    private String parserFactoryRef;

    public FlatpackDataFormat() {
        super("flatpack");
    }

    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public Boolean getFixed() {
        return this.fixed;
    }

    public void setFixed(Boolean fixed) {
        this.fixed = fixed;
    }

    public Boolean getIgnoreFirstRecord() {
        return this.ignoreFirstRecord;
    }

    public void setIgnoreFirstRecord(Boolean ignoreFirstRecord) {
        this.ignoreFirstRecord = ignoreFirstRecord;
    }

    public String getTextQualifier() {
        return this.textQualifier;
    }

    public void setTextQualifier(String textQualifier) {
        this.textQualifier = textQualifier;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public Boolean getAllowShortLines() {
        return this.allowShortLines;
    }

    public void setAllowShortLines(Boolean allowShortLines) {
        this.allowShortLines = allowShortLines;
    }

    public Boolean getIgnoreExtraColumns() {
        return this.ignoreExtraColumns;
    }

    public void setIgnoreExtraColumns(Boolean ignoreExtraColumns) {
        this.ignoreExtraColumns = ignoreExtraColumns;
    }

    public String getParserFactoryRef() {
        return this.parserFactoryRef;
    }

    public void setParserFactoryRef(String parserFactoryRef) {
        this.parserFactoryRef = parserFactoryRef;
    }

    @Override
    protected DataFormat createDataFormat(RouteContext routeContext) {
        DataFormat flatpack = super.createDataFormat(routeContext);
        if (ObjectHelper.isNotEmpty(this.parserFactoryRef)) {
            Object parserFactory = CamelContextHelper.mandatoryLookup(routeContext.getCamelContext(), this.parserFactoryRef);
            this.setProperty(routeContext.getCamelContext(), flatpack, "parserFactory", parserFactory);
        }
        return flatpack;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        if (ObjectHelper.isNotEmpty(this.definition)) {
            this.setProperty(camelContext, dataFormat, "definition", this.definition);
        }
        if (this.fixed != null) {
            this.setProperty(camelContext, dataFormat, "fixed", this.fixed);
        }
        if (this.ignoreFirstRecord != null) {
            this.setProperty(camelContext, dataFormat, "ignoreFirstRecord", this.ignoreFirstRecord);
        }
        if (ObjectHelper.isNotEmpty(this.textQualifier)) {
            if (this.textQualifier.length() > 1) {
                throw new IllegalArgumentException("Text qualifier must be one character long!");
            }
            this.setProperty(camelContext, dataFormat, "textQualifier", Character.valueOf(this.textQualifier.charAt(0)));
        }
        if (ObjectHelper.isNotEmpty(this.delimiter)) {
            if (this.delimiter.length() > 1) {
                throw new IllegalArgumentException("Delimiter must be one character long!");
            }
            this.setProperty(camelContext, dataFormat, "delimiter", Character.valueOf(this.delimiter.charAt(0)));
        }
        if (this.allowShortLines != null) {
            this.setProperty(camelContext, dataFormat, "allowShortLines", this.allowShortLines);
        }
        if (this.ignoreExtraColumns != null) {
            this.setProperty(camelContext, dataFormat, "ignoreExtraColumns", this.ignoreExtraColumns);
        }
    }
}

