/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.util;

public class StringSizedSet {
    public static final double DEFAULT_FILL_FRACTION = 0.4;
    protected final int m_arraySize;
    protected final String[] m_keyTable;
    protected final int m_hitOffset;

    public StringSizedSet(int count, double fill) {
        if (fill <= 0.0 || fill > 0.7) {
            throw new IllegalArgumentException("Fill fraction of " + fill + " is out of allowed range");
        }
        int size = Math.max((int)((double)count / fill), 11);
        size += (size + 1) % 2;
        this.m_arraySize = size;
        this.m_keyTable = new String[size];
        this.m_hitOffset = this.m_arraySize / 2;
    }

    public StringSizedSet(int count) {
        this(count, 0.4);
    }

    private final int stepSlot(int slot) {
        return (slot + this.m_hitOffset) % this.m_arraySize;
    }

    private final int freeSlot(int slot) {
        while (this.m_keyTable[slot] != null) {
            slot = this.stepSlot(slot);
        }
        return slot;
    }

    private final int standardSlot(String key) {
        return (key.hashCode() & Integer.MAX_VALUE) % this.m_arraySize;
    }

    private int standardFind(String key) {
        int slot = this.standardSlot(key);
        while (this.m_keyTable[slot] != null) {
            if (this.m_keyTable[slot].equals(key)) {
                return slot;
            }
            slot = this.stepSlot(slot);
        }
        return -slot - 1;
    }

    public boolean add(String key) {
        if (key == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        int offset = this.standardFind(key);
        if (offset >= 0) {
            return false;
        }
        offset = -offset - 1;
        this.m_keyTable[offset] = key;
        return true;
    }

    public final boolean contains(String key) {
        return this.standardFind(key) >= 0;
    }

    public void clear() {
        for (int i = 0; i < this.m_keyTable.length; ++i) {
            this.m_keyTable[i] = null;
        }
    }
}

