/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.utility;

import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaUtils
extends org.apache.axis2.util.JavaUtils {
    private static Log log = LogFactory.getLog(JavaUtils.class);

    private JavaUtils() {
    }

    public static List getPackagesFromNamespace(String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        String jaxbPkg = JavaUtils.getPackageFromNamespace(namespace, true);
        list.add(jaxbPkg);
        if (jaxbPkg.contains("_")) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Calling getPackageFromNamespace with wsimport rule:" + namespace));
            }
            String altPkg = JavaUtils.getPackageFromNamespace(namespace, false);
            list.add(altPkg);
        }
        return list;
    }

    public static String getPackageFromNamespace(String namespace) {
        return JavaUtils.getPackageFromNamespace(namespace, true);
    }

    public static String getPackageFromNamespace(String namespace, boolean appendUnderscoreToKeyword) {
        String word;
        int i;
        String last;
        String lastWord;
        int index;
        String[] words;
        if (log.isDebugEnabled()) {
            log.debug((Object)("namespace (" + namespace + ")"));
        }
        String hostname = null;
        String path = null;
        try {
            URL url = new URL(namespace);
            hostname = url.getHost();
            path = url.getPath();
        }
        catch (MalformedURLException e) {
            hostname = namespace.indexOf(":") > -1 ? namespace.substring(namespace.indexOf(":") + 1) : namespace;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("hostname (" + hostname + ")"));
            log.debug((Object)("path (" + path + ")"));
        }
        StringTokenizer st = new StringTokenizer(hostname, ":/");
        ArrayList<String> wordList = new ArrayList<String>();
        while (st != null && st.hasMoreTokens()) {
            wordList.add(st.nextToken());
        }
        if (path != null) {
            StringTokenizer pathst = new StringTokenizer(path, "/");
            while (pathst != null && pathst.hasMoreTokens()) {
                wordList.add(pathst.nextToken());
            }
        }
        if ((words = wordList.toArray(new String[0])) != null && words.length > 1 && (index = (lastWord = words[words.length - 1]).lastIndexOf(46)) > 0) {
            words[words.length - 1] = lastWord.substring(0, index);
        }
        if (namespace.startsWith("urn:")) {
            words[0] = JavaUtils.replace((String)words[0], (String)"-", (String)".");
        }
        ArrayList<String> list = new ArrayList<String>();
        if (words.length > 0) {
            StringTokenizer st2 = new StringTokenizer(words[0], ".");
            while (st2.hasMoreTokens()) {
                list.add(0, st2.nextToken());
            }
        }
        if (list.size() > 0 && (last = (String)list.get(list.size() - 1)).equals("www")) {
            list.remove(list.size() - 1);
        }
        for (i = 1; i < words.length; ++i) {
            list.add(words[i]);
        }
        for (i = 0; i < list.size(); ++i) {
            word = (String)list.remove(i);
            word = word.toLowerCase();
            list.add(i, word);
        }
        for (i = 0; i < list.size(); ++i) {
            word = (String)list.get(i);
            if (JavaUtils.isJavaKeyword((String)(word = JavaUtils.replace((String)word, (String)"-", (String)"_")))) {
                word = appendUnderscoreToKeyword ? word + "_" : "_" + word;
            }
            if (!Character.isJavaIdentifierStart(word.charAt(0))) {
                word = "_" + word;
            }
            list.set(i, word);
        }
        String name = "";
        for (int i2 = 0; i2 < list.size(); ++i2) {
            name = i2 == 0 ? (String)list.get(0) : name + "." + (String)list.get(i2);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("package name (" + name + ")"));
        }
        return name;
    }

    public static String stackToString() {
        return JavaUtils.stackToString(new RuntimeException());
    }

    public static String stackToString(Throwable e) {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        PrintWriter pw = new PrintWriter(bw);
        e.printStackTrace(pw);
        pw.close();
        String text = sw.getBuffer().toString();
        text = text.substring(text.indexOf("at"));
        text = JavaUtils.replace((String)text, (String)"at ", (String)"DEBUG_FRAME = ");
        return text;
    }

    public static Class getCheckedException(Throwable throwable, Method method) {
        if (method == null) {
            return null;
        }
        Class<?>[] exceptions = method.getExceptionTypes();
        if (exceptions != null) {
            for (int i = 0; i < exceptions.length; ++i) {
                if (!exceptions[i].isAssignableFrom(throwable.getClass())) continue;
                return exceptions[i];
            }
        }
        return null;
    }

    public static URI createURI(String pathString) {
        URI pathURI = null;
        if (pathString == null || "".equals(pathString)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Path string argument is invalid [" + pathString + "]; returning null"));
            }
            return null;
        }
        try {
            pathURI = new URI(pathString);
        }
        catch (URISyntaxException ex1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Unable to create URI from [" + pathString + "], trying alternative approach"));
            }
            try {
                pathURI = new URI(null, null, pathString, null);
            }
            catch (URISyntaxException ex2) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Unable to create URI using alternative approach; returning null.  Exception caught during inital attempt: " + JavaUtils.stackToString(ex1)));
                    log.trace((Object)("Exception caught during alternet attemt " + JavaUtils.stackToString(ex2)));
                }
                log.error((Object)ex2.toString(), (Throwable)ex2);
            }
        }
        return pathURI;
    }
}

