/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.tool.util;

import java.io.File;
import java.io.IOException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.axis2.tool.service.eclipse.plugin.ServiceArchiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class ServicePluginUtils {
    private static final Log logger = LogFactory.getLog(ServicePluginUtils.class);

    public static boolean isServicesXMLValid(String servicesXmlPath) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            String resourcePath = ServicePluginUtils.addAnotherNodeToPath("resources", "services.xsd");
            Schema schema = factory.newSchema(ServiceArchiver.getDefault().getBundle().getEntry(resourcePath));
            Validator validator = schema.newValidator();
            StreamSource source = new StreamSource(new File(servicesXmlPath));
            validator.validate(source);
            return true;
        }
        catch (SAXException e) {
            logger.debug((Object)"Schema addition failed", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            logger.debug((Object)"Schema validation failed", (Throwable)e);
            return false;
        }
    }

    public static String addAnotherNodeToPath(String currentPath, String newNode) {
        return currentPath + File.separator + newNode;
    }
}

