/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.domain;

import com.ibatis.common.util.PaginatedArrayList;
import com.ibatis.common.util.PaginatedList;
import com.ibatis.jpetstore.domain.CartItem;
import com.ibatis.jpetstore.domain.Item;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Cart
implements Serializable {
    private final Map itemMap = Collections.synchronizedMap(new HashMap());
    private final PaginatedList itemList = new PaginatedArrayList(4);

    public Iterator getCartItems() {
        return this.itemList.iterator();
    }

    public PaginatedList getCartItemList() {
        return this.itemList;
    }

    public int getNumberOfItems() {
        return this.itemList.size();
    }

    public Iterator getAllCartItems() {
        ArrayList allItems = new ArrayList();
        this.itemList.gotoPage(0);
        allItems.addAll(this.itemList);
        while (this.itemList.nextPage()) {
            allItems.addAll(this.itemList);
        }
        return allItems.iterator();
    }

    public boolean containsItemId(String itemId) {
        return this.itemMap.containsKey(itemId);
    }

    public void addItem(Item item, boolean isInStock) {
        CartItem cartItem = (CartItem)this.itemMap.get(item.getItemId());
        if (cartItem == null) {
            cartItem = new CartItem();
            cartItem.setItem(item);
            cartItem.setQuantity(0);
            cartItem.setInStock(isInStock);
            this.itemMap.put(item.getItemId(), cartItem);
            this.itemList.add((Object)cartItem);
        }
        cartItem.incrementQuantity();
    }

    public Item removeItemById(String itemId) {
        CartItem cartItem = (CartItem)this.itemMap.remove(itemId);
        if (cartItem == null) {
            return null;
        }
        this.itemList.remove((Object)cartItem);
        return cartItem.getItem();
    }

    public void incrementQuantityByItemId(String itemId) {
        CartItem cartItem = (CartItem)this.itemMap.get(itemId);
        cartItem.incrementQuantity();
    }

    public void setQuantityByItemId(String itemId, int quantity) {
        CartItem cartItem = (CartItem)this.itemMap.get(itemId);
        cartItem.setQuantity(quantity);
    }

    public BigDecimal getSubTotal() {
        BigDecimal subTotal = new BigDecimal("0");
        Iterator items = this.getAllCartItems();
        while (items.hasNext()) {
            CartItem cartItem = (CartItem)items.next();
            Item item = cartItem.getItem();
            BigDecimal listPrice = item.getListPrice();
            BigDecimal quantity = new BigDecimal(String.valueOf(cartItem.getQuantity()));
            subTotal = subTotal.add(listPrice.multiply(quantity));
        }
        return subTotal;
    }
}

