/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.domain;

import com.ibatis.jpetstore.domain.Item;
import java.io.Serializable;
import java.math.BigDecimal;

public class CartItem
implements Serializable {
    private Item item;
    private int quantity;
    private boolean inStock;
    private BigDecimal total;

    public boolean isInStock() {
        return this.inStock;
    }

    public void setInStock(boolean inStock) {
        this.inStock = inStock;
    }

    public BigDecimal getTotal() {
        return this.total;
    }

    public Item getItem() {
        return this.item;
    }

    public void setItem(Item item) {
        this.item = item;
        this.calculateTotal();
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
        this.calculateTotal();
    }

    public void incrementQuantity() {
        ++this.quantity;
        this.calculateTotal();
    }

    private void calculateTotal() {
        this.total = this.item != null && this.item.getListPrice() != null ? this.item.getListPrice().multiply(new BigDecimal((double)this.quantity)) : null;
    }
}

