/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.persistence;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;

public class LocalHsqldbConfigurator
implements ServletContextListener {
    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        try {
            File propertiesFile = new File(context.getRealPath("WEB-INF/classes/properties/database.properties"));
            if (propertiesFile.exists()) {
                context.log("LocalHsqldbConfigurator: database.properties already exists");
                return;
            }
            String dbPath = context.getRealPath("/WEB-INF/db/jpetstore.script");
            FileWriter output = new FileWriter(propertiesFile);
            output.write("driver=org.hsqldb.jdbcDriver\n");
            output.write("url=jdbc:hsqldb:" + dbPath.substring(0, dbPath.length() - ".script".length()).replace('\\', '/') + "\n");
            output.write("username=sa\n");
            output.write("password=\n");
            output.close();
            context.log("LocalHsqldbConfigurator: database.properties created");
        }
        catch (IOException e) {
            context.log("LocalHsqldbConfigurator: failed to create database.properties", (Throwable)e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

