/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.jpetstore.persistence.sqlmapdao;

import com.ibatis.common.util.PaginatedList;
import com.ibatis.dao.client.DaoManager;
import com.ibatis.jpetstore.domain.LineItem;
import com.ibatis.jpetstore.domain.Order;
import com.ibatis.jpetstore.persistence.iface.OrderDao;
import com.ibatis.jpetstore.persistence.sqlmapdao.BaseSqlMapDao;

public class OrderSqlMapDao
extends BaseSqlMapDao
implements OrderDao {
    public OrderSqlMapDao(DaoManager daoManager) {
        super(daoManager);
    }

    public PaginatedList getOrdersByUsername(String username) {
        return this.queryForPaginatedList("getOrdersByUsername", (Object)username, 10);
    }

    public Order getOrder(int orderId) {
        Order order = null;
        Integer parameterObject = new Integer(orderId);
        order = (Order)this.queryForObject("getOrder", (Object)parameterObject);
        order.setLineItems(this.queryForList("getLineItemsByOrderId", (Object)new Integer(order.getOrderId())));
        return order;
    }

    public void insertOrder(Order order) {
        this.update("insertOrder", (Object)order);
        this.update("insertOrderStatus", (Object)order);
        for (int i = 0; i < order.getLineItems().size(); ++i) {
            LineItem lineItem = (LineItem)order.getLineItems().get(i);
            lineItem.setOrderId(order.getOrderId());
            this.update("insertLineItem", (Object)lineItem);
        }
    }
}

